# Data
# caltech101 / oxford_flowers / dtd / oxford_pets 
# fgvc_aircraft / stanford_cars / sun397 / eurosat

GPU=$1
DATA=$2
TYPE=$3
FORCE_TO_RUN=$4
NOISE_NUM=$5
NOISE_TYPE=$6

if [ "$TYPE" = "PTNL" ]
then
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/train.sh $DATA rn50_ep50 end 16 16 False True run_GCE $NOISE_NUM none $FORCE_TO_RUN True ptnl run $NOISE_TYPE
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/test_existing_logits.sh $DATA rn50_ep50 end 16 16 False True run_GCE $NOISE_NUM none True ptnl $NOISE_TYPE
elif [ "$TYPE" = "NOISY" ]
then
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/train.sh $DATA rn50_ep50 end 16 16 False True run_NOISY $NOISE_NUM none $FORCE_TO_RUN none none run $NOISE_TYPE
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/test_existing_logits.sh $DATA rn50_ep50 end 16 16 False True run_NOISY $NOISE_NUM none True none $NOISE_TYPE
elif [ "$TYPE" = "POND" ]
then
    # Run PoND
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/train.sh $DATA rn50_ep50 end 16 16 False True run_POND $NOISE_NUM union $FORCE_TO_RUN True pond run $NOISE_TYPE
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/test_existing_logits.sh $DATA rn50_ep50 end 16 16 False True run_POND $NOISE_NUM union True pond  $NOISE_TYPE
elif [ "$TYPE" = "DMIX" ]
then
    # Run PoND
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/train.sh $DATA rn50_ep50 end 16 16 False True run_DMIX $NOISE_NUM none $FORCE_TO_RUN none dmix run $NOISE_TYPE
    # CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/test_existing_logits.sh $DATA rn50_ep50 end 16 16 False True run_DMIX $NOISE_NUM none True dmix  $NOISE_TYPE
elif [ "$TYPE" = "UCON" ]
then
    # Run PoND
    CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/train.sh $DATA rn50_ep50 end 16 16 False True run_UCON $NOISE_NUM none $FORCE_TO_RUN none unicon run $NOISE_TYPE
    # CUDA_VISIBLE_DEVICES=$GPU bash ./scripts/test_existing_logits.sh $DATA rn50_ep50 end 16 16 False True run_UCON $NOISE_NUM none True unicon  $NOISE_TYPE
fi

